﻿//////////////////////////////////////////////
// JpgFrame.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	class ImageView ;
}

/// Includes ---------------------------------

// nkImages
#include "../Enums/JpgComponentType.h"

/// Class ------------------------------------

namespace nkImages::jpg
{
	struct JpgFrameComponentDescriptor final
	{
		JPG_COMPONENT_TYPE _type = JPG_COMPONENT_TYPE::COMPONENT_Y ;
		unsigned char _sampling = 0u ;
		unsigned char _quantizationTableIndex = 0u ;

		unsigned char _samplingFactorW = 0u ;
		unsigned char _samplingFactorH = 0u ;
	} ;

	class JpgFrame final
	{
		public :

			// Constructors
			JpgFrame () noexcept ;
			JpgFrame (const ImageView& image) noexcept ;

			// Functions
			// Writing
			unsigned short getMarkerSpotByteSize () const ;
			void writeMarkerSpot (unsigned char* out) ;

			// Parsing
			static JpgFrame parseFromMarker (const unsigned char* data) ;

		public :

			// Attributes
			// Dimension information
			unsigned short _width = 0u ;
			unsigned short _height = 0u ;

			// Pixel info
			unsigned char _bitsPerPixels = 0u ;
			unsigned char _componentCount = 0u ;

			// Component info
			JpgFrameComponentDescriptor _components [3] ;

			// Type
			bool _progressive = false ;
	} ;
}